<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cfg=".">
  <xsl:output method="text"/>
  <!--##############  PARAMETER  ####################-->
  <!-- BEGIN mandatory parameters, set by TrafoValidate -->
  <xsl:param name="Filename" select="'n/a'"/>
  <xsl:param name="IsFirst" select="'false'"/>
  <xsl:param name="IdentKey" select="'n/a'"/>
  <xsl:param name="TimeStamp" select="'2000-01-01 00:00:00'"/>
  <!-- default language is EN if not set with AddXSLTParam -->
  <xsl:param name="Lang" select="'EN'"/>
  <!--##############  VARIABLES  ####################-->
  <xsl:variable name="Language">
    <xsl:choose>
      <!-- additionally DE is supported and used for configs using DE -->
      <xsl:when test="/*/HEADER/@rpsLanguage = 'DE'">EN</xsl:when>
      <xsl:when test="/*/HEADER/@rpsLanguage = 'EN'">EN</xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$Lang"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="INDENT6">
    <xsl:text>&#32;&#32;&#32;&#32;&#32;&#32;</xsl:text>
  </xsl:variable>
  <xsl:variable name="INDENT8">
    <xsl:text>&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;</xsl:text>
  </xsl:variable>
  <xsl:variable name="INDENT10">
    <xsl:text>&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;</xsl:text>
  </xsl:variable>
  <xsl:variable name="INDENT12">
    <xsl:text>&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;</xsl:text>
  </xsl:variable>
  <xsl:variable name="NEWLINE">
    <xsl:text>&#13;&#10;</xsl:text>
  </xsl:variable>
  <!--##############  BEGIN Namspace cfg   ####################-->
  <cfg:Stylesheet mode="EXAMINE" version="$Revision: 1.4 $"/>
  <cfg:Description lang="DE">Suche nach Konfigurationen mit falschen Port-Numerierungen bei Inputs, wenn vorher ein IOP8-Modul konfiguriert ist. Dieser Fehler kann beim Upload mit Transformern der Versionen 1.2.5 oder 1.3.6 entstehen.</cfg:Description>
  <cfg:Description lang="EN">Search for configurations with wrong port numbers in input items configured after an IOP8-module. This error occurrs if the configuration was uploaded using a transformer of version 1.2.5 or 1.3.6.</cfg:Description>
  <cfg:Texts>
    <cfg:Text lang="DE" id="Line1">, Folgende Konfiguartionsdateien enthalten Unstimmigkeiten:</cfg:Text>
    <cfg:Text lang="EN" id="Line1">, the following configuration files may contain defects:</cfg:Text>
    <cfg:Text lang="DE" id="ResultOK">Nicht betroffen.</cfg:Text>
    <cfg:Text lang="EN" id="ResultOK">Not affected.</cfg:Text>
    <cfg:Text lang="DE" id="XSLTNotValid">Das Stylesheet ist nicht gültig. </cfg:Text>
    <cfg:Text lang="EN" id="XSLTNotValid">The stylesheet is invalid. </cfg:Text>
  </cfg:Texts>
  <!--##############  END Namspace cfg   ####################-->
  <!--##############  MAIN Template for any ROOT ####################-->
  <xsl:template match="/">
    <!-- the identkey is written in any case otherwise TrafoValidate assumes an error in the stylesheet -->
    <xsl:if test="$IsFirst = 'true'">
      <xsl:value-of select="$IdentKey"/>
    </xsl:if>
    <!-- IMPORTANT: only the known roots are considered -->
    <xsl:choose>
      <xsl:when test="/CONFIG_NETWORK or /CONFIGURATION">
        <xsl:apply-templates/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>-&gt; </xsl:text>
        <xsl:value-of select="$Filename"/>
        <xsl:text> is not a configuration file.</xsl:text>
        <xsl:value-of select="$NEWLINE"/>
        <xsl:value-of select="$NEWLINE"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- ############ Our expected ROOTS ##################-->
  <xsl:template match="/CONFIG_NETWORK | /CONFIGURATION">
    <xsl:if test="/*/HEADER/filename != ''">
      <xsl:call-template name="WriteFileInfo"/>
      <xsl:choose>
        <!-- error testing -->
        <xsl:when test="name() = 'CONFIG_NETWORK'">
          <xsl:for-each select="//NODES/*">
            <xsl:call-template name="CHECKTrafoUpload">
              <xsl:with-param name="IsNode" select="true"/>
            </xsl:call-template>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="CHECKTrafoUpload">
            <xsl:with-param name="IsNode" select="false"/>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>
  <!-- ######### -->
  <xsl:template name="WriteFileInfo">
    <xsl:text>-&gt; </xsl:text>
    <xsl:value-of select="substring-before(/*/HEADER/filename,'.xml')"/>
    <xsl:text>  (</xsl:text>
    <xsl:value-of select="/*/HEADER/lastModified"/>
    <xsl:text>, </xsl:text>
    <xsl:value-of select="$Filename"/>
    <xsl:text>)</xsl:text>
    <xsl:value-of select="$NEWLINE"/>
  </xsl:template>
  <!-- ######### -->
  <xsl:template name="CHECKTrafoUpload">
    <xsl:param name="IsNode"/>
    <xsl:variable name="TrafoVersion">
      <xsl:value-of select="substring(substring-after(descendant::CONFIG_INFO/cfgDataGenerator,'TrafoDll V'),1,5)"/>
    </xsl:variable>
    <!-- set context PANEL/* in any case -->
    <xsl:for-each select="descendant::NETWORK/PANEL/* | descendant::LOCAL_CONFIGURATION/PANEL/*">
      <xsl:choose>
        <xsl:when test="$TrafoVersion = '1.2.5' or $TrafoVersion = '1.3.6'">
          <!-- only do the first IO8 -->
          <xsl:if test="name() = 'IO_8_MODULE' and count(preceding-sibling::IO_8_MODULE) = 0">
            <!-- now we have an uploaded configuration by the buggy trafo with an IOP8-->
            <xsl:choose>
              <!-- case 1 -->
              <xsl:when test="count(../IO_8_MODULE) > 1">
                <xsl:for-each select="../IO_8_MODULE[count(preceding-sibling::IO_8_MODULE) > 0]/INPUT">
                  <xsl:if test="number(port) > 16">
                    <xsl:variable name="DefText">
                      <xsl:text>DEFECT:  IO_8_MODULE-INPUT with wrong portnumber </xsl:text>
                      <xsl:value-of select="port"/>
                    </xsl:variable>
                    <xsl:call-template name="WriteDefect">
                      <xsl:with-param name="DisplayName" select="../../@rpsDisplayName"/>
                      <xsl:with-param name="DisplayName2" select="../@rpsDisplayName"/>
                      <xsl:with-param name="DisplayName3" select="@rpsDisplayName"/>
                      <xsl:with-param name="DefectText" select="$DefText"/>
                    </xsl:call-template>
                  </xsl:if>
                </xsl:for-each>
              </xsl:when>
              <xsl:otherwise>
                <xsl:for-each select="following-sibling::LSN300_MODULE | following-sibling::LSN1500_MODULE">
                  <xsl:choose>
                    <!-- case 2 -->
                    <xsl:when test="LSN_BUS/LSNI_IN2 or LSN_BUS/LSNI_IN2_D">
                      <xsl:for-each select="LSN_BUS/LSNI_IN2/INPUT | LSN_BUS/LSNI_IN2_D/INPUT">
                        <xsl:if test="number(port) > 2">
                          <xsl:variable name="DefText">
                            <xsl:text>DEFECT: LSNI_IN2-INPUT with wrong portnumber </xsl:text>
                            <xsl:value-of select="port"/>
                          </xsl:variable>
                          <xsl:call-template name="WriteDefect">
                            <xsl:with-param name="DisplayName" select="../../../../@rpsDisplayName"/>
                            <xsl:with-param name="DisplayName1" select="../../../@rpsDisplayName"/>
                            <xsl:with-param name="DisplayName2" select="../../@rpsDisplayName"/>
                            <xsl:with-param name="DisplayName3" select="../@rpsDisplayName"/>
                            <xsl:with-param name="DefectText" select="$DefText"/>
                          </xsl:call-template>
                        </xsl:if>
                      </xsl:for-each>
                    </xsl:when>
                    <!-- case 3 -->
                    <xsl:when test="LSN_BUS/NTK100">
                      <xsl:for-each select="LSN_BUS/NTK100/INPUT">
                        <xsl:if test="number(siNumber) = 0">
                          <xsl:variable name="DefText">
                            <xsl:text>WARNING: Possible defect: NTK100-INPUT not configured, siNumber = 0</xsl:text>
                          </xsl:variable>
                          <xsl:call-template name="WriteDefect">
                            <xsl:with-param name="DisplayName" select="../../../../@rpsDisplayName"/>
                            <xsl:with-param name="DisplayName1" select="../../../@rpsDisplayName"/>
                            <xsl:with-param name="DisplayName2" select="../../@rpsDisplayName"/>
                            <xsl:with-param name="DisplayName3" select="../@rpsDisplayName"/>
                            <xsl:with-param name="DefectText" select="$DefText"/>
                          </xsl:call-template>
                        </xsl:if>
                      </xsl:for-each>
                    </xsl:when>
                    <!-- case 4 -->
                    <xsl:when test="LSN_BUS/NKK100">
                      <xsl:for-each select="LSN_BUS/NKK100/INPUT">
                        <xsl:if test="number(port) > 8">
                          <xsl:variable name="DefText">
                            <xsl:text>DEFECT: NKK100-INPUT with wrong portnumber </xsl:text>
                            <xsl:value-of select="port"/>
                          </xsl:variable>
                          <xsl:call-template name="WriteDefect">
                            <xsl:with-param name="DisplayName" select="../../../../@rpsDisplayName"/>
                            <xsl:with-param name="DisplayName1" select="../../../@rpsDisplayName"/>
                            <xsl:with-param name="DisplayName2" select="../../@rpsDisplayName"/>
                            <xsl:with-param name="DisplayName3" select="../@rpsDisplayName"/>
                            <xsl:with-param name="DefectText" select="$DefText"/>
                          </xsl:call-template>
                        </xsl:if>
                      </xsl:for-each>
                    </xsl:when>
                  </xsl:choose>
                </xsl:for-each>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:if>
        </xsl:when>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>
  <!-- ######### -->
  <xsl:template name="WriteDefect">
    <xsl:param name="DisplayName" select="''"/>
    <xsl:param name="DisplayName1" select="''"/>
    <xsl:param name="DisplayName2" select="''"/>
    <xsl:param name="DisplayName3" select="''"/>
    <xsl:param name="DefectText"/>
    <xsl:value-of select="$INDENT6"/>
    <xsl:value-of select="$DisplayName"/>
    <xsl:value-of select="$NEWLINE"/>
    <xsl:if test="$DisplayName1 != ''">
      <xsl:value-of select="$INDENT8"/>
      <xsl:value-of select="$DisplayName1"/>
      <xsl:value-of select="$NEWLINE"/>
    </xsl:if>
    <xsl:if test="$DisplayName2 != ''">
      <xsl:value-of select="$INDENT10"/>
      <xsl:value-of select="$DisplayName2"/>
      <xsl:if test="$DisplayName3 != ''">
        <xsl:text>   (</xsl:text>
        <xsl:value-of select="$DisplayName3"/>
        <xsl:text>)</xsl:text>
      </xsl:if>
      <xsl:value-of select="$NEWLINE"/>
    </xsl:if>
    <xsl:value-of select="$INDENT12"/>
    <xsl:value-of select="$DefectText"/>
    <xsl:value-of select="$NEWLINE"/>
    <xsl:value-of select="$NEWLINE"/>
  </xsl:template>
</xsl:stylesheet>
